﻿#include	"AjcInternal.h"
#include	"AjcCtrlTimeChartDef.h"
//**************************************************************************************************************//
//																												//
//	カスタムコントロール（タイムチャート）				レンジ設定ダイアログ									//
//																												//
//**************************************************************************************************************//
//--------------------------------------------------------------------------------------------------------------//
//	内部サブ関数																								//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC_DEF(SetRange);

//==============================================================================================================//
//																												//
//	レンジ設定ダイアログボックス生成																			//
//																												//
//==============================================================================================================//
VO		TchDialogBoxSetRange  (PWRKTMCHART pW)
{
	DialogBoxParam(hDllInst, MAKEINTRESOURCE(IDD_TCHSETRANGE), pW->hMain, AJC_DLGPROC_NAME(SetRange), (LPARAM)pW);
}
//--------------------------------------------------------------------------------------------------------------//
//																												//
//	グラフレンジ設定ダイアログプロシージャ																		//
//																												//
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, WM_INITDIALOG	)
{
	PWRKTMCHART	pW = (PWRKTMCHART)lParam;

	//----- ワークポインタをウインドに設定 ------------//
	SetProp(hDlg, L"AjcTchSetRange", pW);
	//----- アイコン設定 ------------------------------//
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcoApp);
	//----- ウインドタイトル設定 ----------------------//
	SetWindowText (hDlg, LNGSEL(L"レンジ設定", L"Set Range"));
	SetDlgItemText(hDlg, IDC_LBL_RNGH, LNGSEL(L"高位レンジ", L"Top Value"	));
	SetDlgItemText(hDlg, IDC_LBL_RNGL, LNGSEL(L"低位レンジ", L"Bottom Value"));
	SetDlgItemText(hDlg, IDOK		 , LNGSEL(L"ＯＫ"	   , L"OK"			));
	SetDlgItemText(hDlg, IDCANCEL	 , LNGSEL(L"キャンセル", L"Cancel"		));
	//----- レンジ値設定 ------------------------------//
	AjcSetDlgItemReal(hDlg, IDC_TXT_RNGH, pW->prop.RngH, -10);
	AjcSetDlgItemReal(hDlg, IDC_TXT_RNGL, pW->prop.RngL, -10);

	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDOK			)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchSetRange");
	AJCTCPROP	prop;

	TchGetProp(pW, &prop);
	prop.RngH = AjcGetDlgItemReal(hDlg, IDC_TXT_RNGH);
	prop.RngL = AjcGetDlgItemReal(hDlg, IDC_TXT_RNGL);
	TchSetProp(pW, &prop);
	EndDialog(hDlg, IDOK);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGPROC(SetRange, IDCANCEL		)
{
	PWRKTMCHART	pW = (PWRKTMCHART)GetProp(hDlg, L"AjcTchSetRange");

	EndDialog(hDlg, IDCANCEL);
	return TRUE;
}
//--------------------------------------------------------------------------------------------------------------//
AJC_DLGMAP_DEF(SetRange)
	AJC_DLGMAP_MSG(SetRange, WM_INITDIALOG	)
	AJC_DLGMAP_CMD(SetRange, IDOK			)
	AJC_DLGMAP_CMD(SetRange, IDCANCEL		)
AJC_DLGMAP_END
